#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import datetime
import os
import shutil

import chdb
import n_gram
import rec10d
import ts2epg
import xml2db
path = str(os.path.dirname(os.path.abspath(__file__))) + "/"
tmppath = path
def update(chtxt):
    print chtxt
    tnow = datetime.datetime.now()
    try:
        lastup = datetime.datetime.strptime(chdb.chtxtsearch(chtxt)[0]['update'], "%Y-%m-%d %H:%M:%S")
    except:
        lastup = datetime.datetime.strptime("2009-04-01 00:00:00", "%Y-%m-%d %H:%M:%S")
    dt = tnow-lastup
    dt = dt.days * 24 * 60 + dt.seconds
    if dt > 2 * 60 * 60:
        ts2epg.write(tmppath + chtxt + "epgdate.xml", chdb.chtxtsearch(chtxt)['ch'])
        xml2db.xml2db(tmppath + chtxt + "epgdate.xml", chdb.chtxtsearch(chtxt)['bctype'])
def updatebc(bctype):
    bctypel = chdb.bctypesearch(bctype)
    print bctypel
    try:
        ts2epg.write(tmppath + bctype + "epgdate.xml", chdb.bctypesearch(bctype)['ch'])
        xml2db.xml2db(tmppath + bctype + "epgdate.xml", bctype)
        shutil.copyfile(tmppath + bctype + "epgdate.xml", tmppath + bctype + "epgdate.bak.xml")
        rec10d.rec10db.update_by_bctype_chdata(bctype)
    except Exception, inst:
        print type(inst)
        print inst
        xml2db.xml2db(tmppath + bctype + "epgdate.bak.xml", bctype)
        rec10d.rec10db.update_status_by_bctype_chdata(bctype, "2")
def updatebc_bak(bctype):
    """
    update epg data by .bak file
    """
    xml2db.xml2db(tmppath + bctype + "epgdate.bak.xml", bctype)
def updateall_bak():
    updatebc_bak("te13")
    updatebc_bak("te20")
    updatebc_bak("te22")
    updatebc_bak("te18")
    updatebc_bak("te19")
    updatebc_bak("te21")
    updatebc_bak("te23")
    updatebc_bak("cs1")
    updatebc_bak("cs2")
    updatebc_bak("bs")
def updateall():
    updatebc("te13")
    updatebc("te20")
    updatebc("te22")
    updatebc("te18")
    updatebc("te19")
    updatebc("te21")
    updatebc("te23")
    updatebc("cs1")
    updatebc("cs2")
    updatebc("bs")
def searchtime2(titletxt, timet, deltatime, chtxt):
    time = datetime.datetime.strptime(timet, "%Y-%m-%d %H:%M:%S")
    ret = []
    deltatime = int(deltatime)
    beforetime = time.strftime("%Y%m%d%H%M%S")
    aftertime = time + datetime.timedelta(hours=deltatime)
    aftertime = aftertime.strftime("%Y%m%d%H%M%S")
    one = ["", "", "", ""]
    tempt = 0
    d = rec10d.rec10db.select_by_time_ngram_tv(beforetime, aftertime, chtxt)
    for chtxtt, title, start, stop in d:
        #print chtxtt+":"+title+":"+start+":"+stop
        p = n_gram.bigram(titletxt, title)
        btime = start
        btime = btime[0:4] + "-" + btime[4:6] + "-" + btime[6:8] + " " + btime[8:10] + ":" + btime[10:12] + ":00"
        etime = stop
        etime = etime[0:4] + "-" + etime[4:6] + "-" + etime[6:8] + " " + etime[8:10] + ":" + etime[10:12] + ":00"
        bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
        dt = bt-time
        dt = 24 * 60 * 60 * dt.days + dt.seconds + 1
        p = p * 90
        dt = 1000-1000 * dt / (7 * 24 * 60 * 60)
        if p > 0:
            p = p + dt
            print dt
        if p > tempt:
            one = [chtxtt, title.encode('utf-8'), btime, etime]
            tempt = p
        if p > 0:
            print title + ":" + str(p) + "点"
    ret = one
    print ret
    return ret
